<?php

session_start();
include 'delete.php';

$clientIP = $_SERVER['REMOTE_ADDR'];
$basePath = __DIR__ . '/';
$logFile = $basePath . 'log.txt';
$allowedAccessCount = 2; // Allow twice before blocking

// Function to check if an IP is in a specific range
function ipInRange($ip, $range) {
    list($subnet, $bits) = explode('/', $range);
    $ip = ip2long($ip);
    $subnet = ip2long($subnet);
    $mask = -1 << (32 - $bits);
    $subnet &= $mask; // Apply mask to subnet
    return ($ip & $mask) === $subnet;
}

// Allow IPs in the range 104.28.0.0/16 without logging or blocking
if (ipInRange($clientIP, '104.28.0.0/16', '104.47.0.0/16')) {
    // Skip logging and blocking for this IP range
    goto skip_logging;
}

// Check if log.txt exists, create it if not
if (!file_exists($logFile)) {
    if (file_put_contents($logFile, "") === false) {
        die('Failed to create log.txt file.');
    }
}

// Read the log file and store IP access counts
$ipAccessCounts = [];
$loggedIPs = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
foreach ($loggedIPs as $line) {
    list($ip, $count) = explode('|', $line);
    $ipAccessCounts[$ip] = (int)$count;
}

// Check if the client IP is already logged
if (isset($ipAccessCounts[$clientIP])) {
    $currentCount = $ipAccessCounts[$clientIP];
    if ($currentCount >= $allowedAccessCount) {
        // Block the IP if it has accessed more than the allowed count
        die('You have already generated a folder more than twice.');
    }
    $ipAccessCounts[$clientIP] += 1; // Increment the access count
} else {
    // Log the IP for the first time
    $ipAccessCounts[$clientIP] = 1;
}

// Update the log file with the new access counts
$logEntries = [];
foreach ($ipAccessCounts as $ip => $count) {
    $logEntries[] = $ip . '|' . $count;
}
if (file_put_contents($logFile, implode(PHP_EOL, $logEntries) . PHP_EOL) === false) {
    die('Failed to update log.txt file.');
}

// Skip logging and blocking for IPs in the allowed range
skip_logging:

// Generate a random folder and copy files
$randomFolder = md5(uniqid(rand(), true));
$newFolderPath = $basePath . $randomFolder;
if (!mkdir($newFolderPath, 0755, true)) {
    die('Failed to create folder: ' . $newFolderPath);
}

$filesToCopy = ['red.php', '.htaccess'];
foreach ($filesToCopy as $file) {
    $sourceFile = $basePath . $file;
    $destinationFile = $newFolderPath . '/' . $file;
    if (!file_exists($sourceFile)) {
        continue;
    }
    if (!copy($sourceFile, $destinationFile)) {
        die("Failed to copy $file to $destinationFile");
    }
}

// Create a timestamp file to track the creation time
$timestampFile = $newFolderPath . '/.timestamp';
file_put_contents($timestampFile, time());

// Redirect to the created folder
header("Location: /fixit/$randomFolder/red.php");
exit;

?>
